clear all
wlen=200;
totalpoints=12000;
allemg=[];
figure
set(gcf,'doublebuffer','on')
subplot(311)
P1=plot(zeros(wlen,1));
axis([0 wlen -1 1]), grid('on')
subplot(312)
P2=plot(zeros(wlen,1));
axis([0 wlen -5 5]), grid('on')
subplot(313)
P3=plot(zeros(wlen,1));
axis([0 wlen -1 1]), grid('on')
AI = analoginput('nidaq',1);
chanI = addchannel(AI,[2 4 6]);
set(AI, 'SampleRate', 1000);
ActualRate = get(AI, 'SampleRate');
set(AI, 'SamplesPerTrigger', totalpoints);
set(AI, 'TriggerType', 'Manual');
start(AI);
trigger(AI);
for i=1:totalpoints/wlen;
    emg=getdata(AI,wlen);
    emg1=emg(:,1);
    emg2=emg(:,2);
    emg3=emg(:,3);
    emg1=emg1-mean(emg1);
    emg2=emg2-mean(emg2);
    emg3=emg3-mean(emg3);
    set(P1,'ydata',emg1);
    set(P2,'ydata',emg2);
    set(P3,'ydata',emg3);
    drawnow
    out1=sum(prod([emg1';emg1']));
    out2=sum(prod([emg2';emg2']));
    out3=sum(prod([emg3';emg3']));
    %  outdata(i)=abs(out(wlen));
    %  outdata(i)=out;
    %  allemg=[allemg emg'];
    send=SendOSCMessage('10.104.11.21',7770,'/emg1',out1); %60 b6000
    send=SendOSCMessage('10.104.11.21',7770,'/emg2',emg2);
    send=SendOSCMessage('10.104.11.21',7770,'/emg3',out3);
end
% subplot(211)
% plot(outdata)
% subplot(212)
% plot(allemg)
delete(AI)
clear AI

